# Security

### Will TrickyStore expose my private keys?

It depends. At most times, your private keys generated by the Android Keystore Provider remain securely in TEE/Strongbox and are never exposed to TrickyStore or other Android softwares. However, there are two exceptions:

* Usually, TrickyStore uses the keybox.xml to (re)sign the certificate of a public key from Android Keystore, if such certificate contains an attestation extension which includes verified boot status. However, applications can explicitly choose another attest key in the Keystore to sign a newly generated public key certificate. In this case, TrickyStore has to know the private key of the said attest key in order to be able to (re)sign the certificate, thus will generate a new attest key or intercept an imported one on the software level.

* On certain brand's devices (such as Oneplus), the OEM disabled the Android Keystore Provider's ability to generate asymmetric keys while the bootloader is unlocked (commonly known as teeBroken). In this case, TrickyStore has to act in the stead of Android Keystore to handle all asymmetric keys generation, which is known as 'generate mode' compared to the usual 'hack mode'.

When TrickyStore determines it is necessary to own a private key, it is stored in the '/data/adb/tricky_store/key_db' in a sqlite database. This directory is only accessible by the root user thus offering some protection from regular applications.

### Will TrickyStore compromise the chain of trust by re-signing certificates?

TrickyStore currently does not check if the certificate chain of to-be-hacked keys is valid. Even if it does check it according to Google's terms, given the readily available keyboxs on the Internet, any attacker can bypass this check if they sign their key with a valid keybox.

### If you have any suggestion to improve TrickyStore's security or point out any other security flaws, feel free to open an issue.